package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.entity.AppUserJobLevel;
import com.github.wxiaoqi.security.admin.mapper.AppUserJobLevelMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 用户身份职位表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-09 10:00:42
 */
@Transactional
@Service
public class AppUserJobLevelBiz extends BaseBiz<AppUserJobLevelMapper, AppUserJobLevel> {


	public Map<Integer, AppUserJobLevel> findJobIdAndJobMapByIds(List<Integer> jobIds) {
		Map<Integer, AppUserJobLevel> postionMap = new HashMap<>();
		List<AppUserJobLevel> data = mapper.selectByIdList(jobIds);
		if (CollectionUtils.isEmpty(data)) {
			return postionMap;
		}
		postionMap = data.stream().collect(Collectors.toMap(AppUserJobLevel::getId, Function.identity()));
		return postionMap;
	}

	public Map<Integer, String> findJobIdAndNameMap() {
		List<AppUserJobLevel> postions = selectListAll();
		return postions.stream().collect(Collectors.toMap(AppUserJobLevel::getId, AppUserJobLevel::getName));
	}

	public AppUserJobLevel selectByName(String name) {
		Example example = new Example(AppUserJobLevel.class);
		example.createCriteria().andEqualTo("name", name);
		return mapper.selectOneByExample(example);
	}

	public Integer selectMaxJobLevel() {
		Integer level = mapper.selectMaxJobLevel();
		return level == null ? 1 : level + 1;
	}

}