package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 银行卡绑定表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "app_user_bank_card")
public class AppUserBankCard implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "userid")
	@ApiModelProperty(value = "用户id")
    private String userid;
	
	    /**
     *  绑定银行时的流水号，用于支付，退款，提现
     */
    @Column(name = "bindingSN")
	@ApiModelProperty(value = "绑定银行时的流水号，用于支付，退款，提现")
    private String bindingsn;
	
	    /**
     *  银行编号
     */
    @Column(name = "bankID")
	@ApiModelProperty(value = "银行编号")
    private String bankid;
	
	    /**
     *  账户名称
     */
    @Column(name = "accountName")
	@ApiModelProperty(value = "账户名称")
    private String accountname;
	
	    /**
     *  账户银行卡号
     */
    @Column(name = "accountNo")
	@ApiModelProperty(value = "账户银行卡号")
    private String accountno;
	
	    /**
     *  开户证件 0身份证 1户口簿 2护照
     */
    @Column(name = "identificationType")
	@ApiModelProperty(value = "开户证件 0身份证 1户口簿 2护照")
    private String identificationtype;
	
	    /**
     *  证件号
     */
    @Column(name = "identificationNo")
	@ApiModelProperty(value = "证件号")
    private String identificationno;
	
	    /**
     *  手机号 用于收取验证码
     */
    @Column(name = "phoneNo")
	@ApiModelProperty(value = "手机号 用于收取验证码")
    private String phoneno;
	
	    /**
     *  是否默认 用于提现有指定账户 1表示默认，0表示不默认
     */
    @Column(name = "isDefault")
	@ApiModelProperty(value = "是否默认 用于提现有指定账户 1表示默认，0表示不默认")
    private Integer isdefault;
	
	    /**
     *  绑定时间
     */
    @Column(name = "bindTime")
	@ApiModelProperty(value = "绑定时间")
    private Integer bindtime;
	
	    /**
     *  1:绑定,0:解绑
     */
    @Column(name = "flag")
	@ApiModelProperty(value = "1:绑定,0:解绑")
    private Integer flag;
	
	    /**
     *  解绑时间
     */
    @Column(name = "unBindTime")
	@ApiModelProperty(value = "解绑时间")
    private Integer unbindtime;
	
	    /**
     *  解绑人员
     */
    @Column(name = "unBindUserId")
	@ApiModelProperty(value = "解绑人员")
    private String unbinduserid;
	
	    /**
     *  绑定人员
     */
    @Column(name = "bundUserId")
	@ApiModelProperty(value = "绑定人员")
    private String bunduserid;
	
	    /**
     *  解绑绑定银行时的流水号
     */
    @Column(name = "unBindingSN")
	@ApiModelProperty(value = "解绑绑定银行时的流水号")
    private String unbindingsn;
	
	    /**
     *  银行名称
     */
    @Column(name = "bankname")
	@ApiModelProperty(value = "银行名称")
    private String bankname;
	
	    /**
     *  分支行名称
     */
    @Column(name = "subbranch_name")
	@ApiModelProperty(value = "分支行名称")
    private String subbranchName;
	
	    /**
     *  分支行省份
     */
    @Column(name = "subbranch_province")
	@ApiModelProperty(value = "分支行省份")
    private String subbranchProvince;
	
	    /**
     *  分支行城市
     */
    @Column(name = "subbranch_city")
	@ApiModelProperty(value = "分支行城市")
    private String subbranchCity;
	

}
