package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityAttendanceRecordBiz;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/4 14:56
 */
@RestController
@RequestMapping("activityAttendanceRecord")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityAttendanceRecordController {
   private final ActivityAttendanceRecordBiz activityAttendanceRecordBiz;

    /**
     * 判断是否还有抽奖机会
     *
     * @param activityId
     * @param prizeType
     * @param appUserDTO
     * @return
     */
    @GetMapping("/number_of_luckydraw/{activityId}/{prizeType}")
    public ObjectRestResponse<Boolean> hasNumberOfLuckyDrawByType(@PathVariable(value = "activityId") Integer activityId,
                                                                  @PathVariable(value = "prizeType") Integer prizeType,
                                                                  AppUserDTO appUserDTO) {
        Boolean state = activityAttendanceRecordBiz.hasNumberOfLuckyDrawByType(activityId,prizeType,appUserDTO.getUserid());
        return ObjectRestResponse.succ(state);
    }

    @PostMapping("/attend/{activityId}")
    public ObjectRestResponse<Void> attendActivity(@PathVariable(value = "activityId") Integer activityId,
                                                   @RequestParam(value = "activityName",required = false) String activityName, AppUserDTO appUserDTO){
        activityAttendanceRecordBiz.attendActivity(activityId,activityName,appUserDTO);
        return ObjectRestResponse.succ();
    }
}