package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleUserReserveBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.pojo.dto.VehicleUserReserveDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleUserReserveVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@RestController
@IgnoreClientToken
@RequestMapping("reserve")
public class VehicleUserReserveController extends BaseController<VehicleUserReserveBiz> {




    @ApiOperation("查询预定列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ObjectRestResponse getList(VehicleUserReserveDTO reserveDTO, AppUserDTO appUserDTO){
        return  baseBiz.getList(reserveDTO,appUserDTO.getUserid());
    }

    @ApiOperation("添加预定信息")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/updReserve", method = RequestMethod.POST)
    public ObjectRestResponse updReserve(@RequestBody VehicleUserReserveVo reserveVo){
        return  baseBiz.updReserve(reserveVo);
    }






}
