package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 车型
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-21 14:15:27
 */
public interface VehicleModelMapper extends Mapper<VehicleModel> {

    List<VehicleModelVo> findVehicleModelPage(VehicleModelQueryCondition vmqc);

    /**
     * 根据车型id和车型某个订单的评价的平均分值计算
     * @param modelId
     * @param avgScore
     * @return
     */
    int updateScoreByModelIdAndavgScore(@Param("modelId") Integer modelId, @Param("avgScore") int avgScore);
}
