package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 用车调度申请
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_dispatch_info")
public class VehicleDispatchInfo implements Serializable {
	private static final long serialVersionUID = 1L;

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;

    @Column(name = "account_id")
    @ApiModelProperty(value = "账号id")
    private Integer accountId;

    @Column(name = "account_name")
    @ApiModelProperty(value = "账号名称")
    private String accountName;

    @Column(name = "company_id")
    @ApiModelProperty(value = "申请分公司id")
    private Integer companyId;

    @Column(name = "mode_id")
    @ApiModelProperty(value = "车型id")
    private Integer modeId;


    @Column(name = "user")
	@ApiModelProperty(value = "使用人")
    private String user;
	

    @Column(name = "user_tel")
	@ApiModelProperty(value = "使用人电话")
    private String userTel;

    @Column(name = "start_time")
    @ApiModelProperty(value = "用车开始时间" )
    private Long startTime;

    @Column(name = "end_time")
    @ApiModelProperty(value = "用车结束时间")
    private Long endTime;

    @Column(name = "wish_ret_company")
    @ApiModelProperty(value = "期望还车公司")
    private Integer wishRetCompany;

    @Column(name = "book_type")
    @ApiModelProperty(value = "用途(枚举类)")
    private Integer bookType;

    @Column(name = "book_remark")
    @ApiModelProperty(value = "用途备注")
    private String bookRemark;

    @Column(name = "reason")
    @ApiModelProperty(value = "拒绝原因")
    private String reason;

    @Column(name = "status")
    @ApiModelProperty(value = "状态：0-申请中；1-已通过；2-拒绝")
    private Integer status;

    @Column(name = "record_ids")
    @ApiModelProperty(value = "预约ids（逗号隔开）")
    private String recordIds;

    @Column(name = "status_time")
    @ApiModelProperty(value = "通过审核时间")
    private Long statusTime;

    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间")
    private Long crtTime;
	

    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间")
    private Long updTime;

    @Column(name = "isdel")
    @ApiModelProperty(value = "删除状态 0：有效 1：删除")
    private Integer isdel;
	

}
