package com.xxfc.platform.user.behavior;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import tk.mybatis.spring.annotation.MapperScan;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/12 10:04
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = {"com.xxfc.platform.*.feign","com.github.wxiaoqi.security.*.feign"})
@MapperScan(basePackages = "com.xxfc.platform.user.behavior.mapper")
@SpringBootApplication(scanBasePackages ={
        "com.xxfc.platform",
        "com.github.wxiaoqi.security.admin.support"
},exclude = {MongoAutoConfiguration.class})
public class UserBeHaviorApplication {
    public static void main(String[] args) {
        SpringApplication.run(UserBeHaviorApplication.class,args);
    }
}
