package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.universal.biz.SysRegionBiz;
import com.xxfc.platform.universal.constant.ResCode;
import com.xxfc.platform.universal.dto.RegionDTO;
import com.xxfc.platform.universal.entity.SysRegion;
import com.xxfc.platform.universal.msg.CustomIllegalParamException;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Arrays;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.List;

@RestController
@RequestMapping("/sysRegion")
@IgnoreClientToken
@Slf4j
public class SysRegionController extends BaseController<SysRegionBiz,SysRegion> {


    /**
     * 父类id获取子类对象
     * @param id
     * @return
     */
    @IgnoreUserToken
    @RequestMapping(value ="/sons/{id}",method = RequestMethod.GET)
    public ObjectRestResponse<List<SysRegion>> getSonRegion(@PathVariable Long id){
        return ObjectRestResponse.succ(baseBiz.getSonRegion(id));
    }

    /**
     * 通过属性获取省
     * @param type
     * @return
     */
    @IgnoreUserToken
    @RequestMapping(value ="/getSonRegionByType/{type}",method = RequestMethod.GET)
    public ObjectRestResponse<List<SysRegion>> getSysRegionByType(@PathVariable Integer type){
        return ObjectRestResponse.succ(baseBiz.getSysRegionByType(type));
    }


    @RequestMapping(value ="",method = RequestMethod.GET)
    public ObjectRestResponse<List<SysRegion>> getRegion(@RequestParam String idListJson){
        try {
            List<Long> ids = JSON.parseArray(idListJson,Long.class);
            return ObjectRestResponse.succ(baseBiz.getRegionsByCodes(ids));
        } catch (JSONException ex) {
            return ObjectRestResponse.createFailedResultMsg(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex){
            return ObjectRestResponse.createFailedResultMsg(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }

    /**
     * 根据多个id查找省份
     * @param ids
     * @return
     */
    @GetMapping("/getSysRegionByIds/{ids}")
    public ObjectRestResponse getSysRegionByIds(@PathVariable String ids){
        Example exam = Example.builder(SysRegion.class)
                .where(WeekendSqls.<SysRegion>custom()
                        .andIn(SysRegion::getId, Arrays.asList(ids.split(",")))).build();
        return ObjectRestResponse.succ( baseBiz.selectByExample(exam));

    }

    /**
     * 通过城市名查询
     * @param city
     * @return
     */
    @GetMapping("/region_name")
    public RegionDTO getRegionByCityName(@RequestParam(value = "city") String city){
        return baseBiz.findRegionByCityName(city);
    }
}
