package com.xxfc.platform.universal.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.universal.entity.LicensePlateType;
import com.xxfc.platform.universal.mapper.LicensePlateTypeMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.List;

@Service
public class LicensePlateTypeBiz extends BaseBiz<LicensePlateTypeMapper, LicensePlateType> {

    /**
     * 获取车牌类型和和编码
     * @param licensePlateTypes
     */
    @Transactional
    public void insertLicensePlateType(List<LicensePlateType> licensePlateTypes) {
        mapper.insertLicensePlateType(licensePlateTypes);
    }

    /**
     * 修改数据库数据
     * @param licensePlateTypes
     * @throws SQLException
     */
    @Transactional
    public void updateLicensePlateType(List<LicensePlateType> licensePlateTypes) throws SQLException {
//        List<LicensePlateType> saveLicensePlateTypes = mapper.selectAll();
//        HashSet<LicensePlateType> judgeSet = new HashSet<>();
//       judgeSet.addAll(saveLicensePlateTypes);
//        for (LicensePlateType licensePlateType : licensePlateTypes) {
//
//            if (judgeSet.add(licensePlateType)) {
//
//                mapper.updateByExample()
//            }
//        }
        for (LicensePlateType licensePlateType : licensePlateTypes) {
            Example exa =   Example.builder(LicensePlateType.class)
                    .where(
                            WeekendSqls.<LicensePlateType>custom()
                                    .andEqualTo(LicensePlateType::getCode,licensePlateType.getCode())
                    ).build();
            int flag = mapper.updateByExample(licensePlateType,exa);
            if (flag==0) {
                insertSelective(licensePlateType);
            }
            if (flag>1) {
                throw new SQLException("修改错误,同时修改多条数据");
            }
        }

    }
}
