package com.xxfc.platform.uccn.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.vo.CampsiteShopPageVo;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.uccn.biz.SearchBiz;
import com.xxfc.platform.uccn.comstnt.ServiceConstant;
import com.xxfc.platform.uccn.entity.Article;
import com.xxfc.platform.uccn.vo.SearchResultVo;
import com.xxfc.platform.uccn.vo.ServiceResultVo;
import com.xxfc.platform.uccn.vo.SummitActivityVo;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.BranchCompanyListVO;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/17 9:47
 */
@RestController
@RequestMapping("/app/unauth/search")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api(tags = "官网*综合搜索")
public class SearchController {

    private final SearchBiz searchBiz;

    private final VehicleModelController vehicleModelController;

    private final GwTourController gwTourController;

    private final CampsiteUccnController campsiteUccnController;

    private final ArticleController articleController;

    private final SummitActivityController summitActivityController;

    private final BranchCompanyController branchCompanyController;

    @GetMapping
    public ObjectRestResponse search(@RequestParam(value = "type", required = false,defaultValue = "") String type,
                                     @RequestParam(value = "keyword", required = false) String keyWord,
                                     @RequestParam(value = "page", required = false, defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit", required = false, defaultValue = "10") Integer limit) {
        switch (type) {
            case ServiceConstant.VEHICLE:
                VehicleModelQueryCondition vehicleModelQueryCondition = new VehicleModelQueryCondition();
                vehicleModelQueryCondition.setPage(page);
                vehicleModelQueryCondition.setLimit(limit);
                vehicleModelQueryCondition.setVehicleName(keyWord);
                ObjectRestResponse<PageDataVO<VehicleModelVo>> vehicleResult =vehicleModelController.findVehicleModelPageUnauthfind(vehicleModelQueryCondition);
                List<VehicleModelVo> vehicleModelVoList = vehicleResult.getData().getData();
                Long vehicleTotalCount = vehicleResult.getData().getTotalCount();
                ServiceResultVo<VehicleModelVo> vehicleModelVoServiceResultVo = new ServiceResultVo<>();
                vehicleModelVoServiceResultVo.setData(vehicleModelVoList);
                vehicleModelVoServiceResultVo.setTotalCount(vehicleTotalCount);
                SearchResultVo searchResultVo = new SearchResultVo();
                searchResultVo.put(ServiceConstant.VEHICLE,vehicleModelVoServiceResultVo);
                return  ObjectRestResponse.succ(searchResultVo);

            case ServiceConstant.BRANCH_COMPANY:
                BranchCompanyFindDTO branchCompanyFindDTO = new BranchCompanyFindDTO();
                branchCompanyFindDTO.setPage(page);
                branchCompanyFindDTO.setLimit(limit);
                branchCompanyFindDTO.setName(keyWord);
                ObjectRestResponse<PageDataVO>  branchResult = branchCompanyController.listBranchCompanyWithPage(branchCompanyFindDTO);
                List branchCompanyList = branchResult.getData().getData();
                Long branchCompanyTotalCount = branchResult.getData().getTotalCount();
                ServiceResultVo<BranchCompanyListVO> companyServiceResultVo = new ServiceResultVo<>();
                companyServiceResultVo.setData(branchCompanyList);
                companyServiceResultVo.setTotalCount(branchCompanyTotalCount);
                SearchResultVo branchCompanyResultVo = new SearchResultVo();
                branchCompanyResultVo.put(ServiceConstant.BRANCH_COMPANY,companyServiceResultVo);
                return ObjectRestResponse.succ(branchCompanyResultVo);
            case ServiceConstant.TROUR:
                ObjectRestResponse goodresult = gwTourController.getGoodList(page, limit, null, keyWord);
                PageDataVO<TourGood> data = (PageDataVO<TourGood>)goodresult.getData();
                List<TourGood> tourGoodList = data.getData();
                Long tourGoodTotalCount = data.getTotalCount();
                ServiceResultVo<TourGood> tourGoodServiceResultVo = new ServiceResultVo<>();
                tourGoodServiceResultVo.setData(tourGoodList);
                tourGoodServiceResultVo.setTotalCount(tourGoodTotalCount);
                SearchResultVo tourGoodSearchResult =  new SearchResultVo();
                tourGoodSearchResult.put(ServiceConstant.TROUR,tourGoodServiceResultVo);
                return ObjectRestResponse.succ(tourGoodSearchResult);
            case ServiceConstant.CAMPSITE:
                ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> campsiteResult = campsiteUccnController.findCampsiteShopPageByType(null, page, limit, keyWord);
                List<CampsiteShopPageVo> campsiteShopPageVoList = campsiteResult.getData().getData();
                Long campsiteTotalCount = campsiteResult.getData().getTotalCount();
                ServiceResultVo<CampsiteShopPageVo> campsiteShopPageVoServiceResultVo = new ServiceResultVo<>();
                campsiteShopPageVoServiceResultVo.setData(campsiteShopPageVoList);
                campsiteShopPageVoServiceResultVo.setTotalCount(campsiteTotalCount);
                SearchResultVo campsiteSearchResultVo = new SearchResultVo();
                campsiteSearchResultVo.put(ServiceConstant.CAMPSITE,campsiteShopPageVoServiceResultVo);
                return ObjectRestResponse.succ(campsiteSearchResultVo);
            case ServiceConstant.NEWS:
                ObjectRestResponse articleresult = articleController.getArticleList(page, limit, 1, keyWord);
                PageInfo<Article> articlePageDataVO = (PageInfo<Article>)articleresult.getData();
                List<Article> articleList = articlePageDataVO.getList();
                Long articleTotalCount = articlePageDataVO.getTotal();
                ServiceResultVo<Article> articleServiceResultVo = new ServiceResultVo<>();
                articleServiceResultVo.setTotalCount(articleTotalCount);
                articleServiceResultVo.setData(articleList);
                SearchResultVo  articleSearchResult= new SearchResultVo();
                articleSearchResult.put(ServiceConstant.NEWS,articleServiceResultVo);
                return ObjectRestResponse.succ(articleSearchResult);
            case ServiceConstant.ACTIVITY:
                ObjectRestResponse<PageDataVO<SummitActivityVo>> summitActivityWithPage = summitActivityController.findSummitActivityWithPage(page, limit, null, keyWord);
                List<SummitActivityVo> summitActivityVos = summitActivityWithPage.getData().getData();
                Long summitTotalCount = summitActivityWithPage.getData().getTotalCount();
                ServiceResultVo<SummitActivityVo> summitActivityVoServiceResultVo = new ServiceResultVo<>();
                summitActivityVoServiceResultVo.setData(summitActivityVos);
                summitActivityVoServiceResultVo.setTotalCount(summitTotalCount);
                SearchResultVo summitActivitySearchResult = new SearchResultVo();
                summitActivitySearchResult.put(ServiceConstant.ACTIVITY,summitActivityVoServiceResultVo);
                return ObjectRestResponse.succ(summitActivitySearchResult);
            default:
                return ObjectRestResponse.succ(searchBiz.searchWithKeyWords(keyWord));
        }
    }
}
