package com.xxfc.platform.uccn.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/26 16:17
 */
@Data
public class SummitActivityDetailVo implements Serializable {
    private static final long serialVersionUID = 1L;

    private Integer id;

    @ApiModelProperty(value = "活动主标题")
    private String title;


    @ApiModelProperty(value = "副标题（不展示）")
    private String subtitle;


    @ApiModelProperty(value = "活动主图")
    private String banner;


    @ApiModelProperty(value = "开始时间")
    private Long startTime;


    @ApiModelProperty(value = "结束时间")
    private Long endTime;


    @ApiModelProperty(value = "报名截止时间（不展示）")
    private Long regCloseTime;



    @ApiModelProperty(value = "省")
    private String province;


    @ApiModelProperty(value = "市")
    private String city;



    @ApiModelProperty(value = "县/镇")
    private String town;


    @ApiModelProperty(value = "活动场地（地址格式）")
    private String address;


    @ApiModelProperty(value = "总人数")
    private Integer limitNum;


    @ApiModelProperty(value = "活动图文内容")
    private String content;

    @ApiModelProperty(value = "报名开关（0开，1关）")
    private Integer isOpenReg;


    @ApiModelProperty(value = "活动对象说明（不展示）")
    @JsonIgnore
    private String actDesc;

    @ApiModelProperty(value = "活动类型(保留，不展示)")
    @JsonIgnore
    private Integer type;

    @ApiModelProperty(value = "报名人数（不展示）")
    @JsonIgnore
    private Integer willNum;

    @ApiModelProperty("seo*html标签优化")
    private String alt;

    @ApiModelProperty("seo*html标签优化")
    private String imgTitle;

    @ApiModelProperty("seo*html标签优化")
    private String imgKeyword;

    @ApiModelProperty("seo*html标签优化")
    private String imgDesc;
}
