package com.xxfc.platform.uccn.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javafx.scene.input.Mnemonic;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Data
@Table(name = "model")
@ApiModel(value = "官网模块实体")
@NoArgsConstructor
public class Model implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键")
    private Integer id;

    @Column(name = "parent_id")
    @ApiModelProperty(value = "父模块id")
    private Integer parentId;

    @Column(name = "name")
    @ApiModelProperty(value = "模块名称")
    private String name;

    @Column(name = "level")
    @ApiModelProperty(value = "模块等级")
    private Integer level;

    @Column(name = "cre_time")
    @ApiModelProperty(value = " 创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date creTime;

    @Column(name = "upd_time")
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updTime;

    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除")
    private Integer isDel;

    @Column(name = "rank")
    @ApiModelProperty(value = "排序")
    private Integer rank;

    public Model(Integer id) {
        this.id = id;
    }
}
