package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourGoodBiz;
import com.xxfc.platform.tour.biz.TourGoodDetailBiz;
import com.xxfc.platform.tour.biz.TourTagBiz;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.entity.TourTag;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

@RestController
@RequestMapping("gw")
@IgnoreClientToken
@IgnoreUserToken
public class TourGwController extends BaseController<TourGoodBiz, TourGood> {



    @Autowired
    TourGoodDetailBiz goodDetailBiz;
    @Autowired
    TourTagBiz tourTagBiz;

    /**
     * 查询旅游路线列表
     *
     * @param page
     * @param limit
     * @param tagId
     * @return
     */
    @ApiOperation("查询旅游路线列表")
    @RequestMapping(value = "/app/unauth/getGoodList", method = RequestMethod.GET)
    public ObjectRestResponse<PageDataVO<TourGood>> getGoodList(@RequestParam(value = "page",defaultValue = "1") Integer page,
                                                      @RequestParam(value = "limit",defaultValue = "10") Integer limit,
                                                      @RequestParam(value = "tagId", required = false) Integer tagId,
                                                      @RequestParam(value = "name",required = false) String name) {
        return baseBiz.getGoodList(page, limit, name, null, null, tagId, null);
    }

    @GetMapping("/app/unauth/detail/{id}")
    public ObjectRestResponse getOne(@PathVariable Integer id) {
        return goodDetailBiz.getGoodDetaileById(id);
    }

    @ApiOperation("首页旅游列表")
    @GetMapping(value = "/shopList")
    public List<GoodDataVO> goodListAll(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit",defaultValue = "4") Integer limit) {
        return baseBiz.getAllByHome(page,limit);
    }

    @ApiOperation("旅游标签列表")
    @GetMapping(value = "/tagList")
    public List<TourTag> tagList(@RequestParam(value = "isHot",defaultValue = "0")Integer isHot) {
        return tourTagBiz.getTagList(isHot);
    }




}