package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourGoodBiz;
import com.xxfc.platform.tour.dto.GoodSearchDTO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.vo.TourGoodVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("tourGood")
public class TourGoodController extends BaseController<TourGoodBiz, TourGood> {

    /**
     * 查询旅游路线列表
     *
     * @param page
     * @param limit
     * @param query
     * @param latitude
     * @param longitude
     * @param tagId
     * @param distance
     * @return
     */
    @ApiOperation("查询旅游路线列表")
    @RequestMapping(value = "/app/unauth/getGoodList", method = RequestMethod.GET)
    @IgnoreClientToken
    @ResponseBody
    public ObjectRestResponse<PageDataVO<TourGood>> getGoodList(@RequestParam(value = "page", required = true) Integer page, @RequestParam(value = "limit",defaultValue = "10") Integer limit,
                                                                @RequestParam(value = "query", required = false) String query, @RequestParam(value = "latitude", required = false) Double latitude,
                                                                @RequestParam(value = "longitude", required = false) Double longitude, @RequestParam(value = "tagId", required = false) Integer tagId,
                                                                @RequestParam(value = "distance", defaultValue = "100") Double distance) {
        return baseBiz.getGoodList(page, limit, query, latitude, longitude, tagId, distance);
    }

    @GetMapping("/app/unauth/usable/{id}")
    public ObjectRestResponse<TourGood> getOne(@PathVariable Integer id) {
        return ObjectRestResponse.succ(baseBiz.getOne(id));
    }

    @ApiOperation("首页旅游列表")
    @GetMapping(value = "/app/shopList")
    public List<GoodDataVO> goodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit",defaultValue = "4") Integer limit) {
        return baseBiz.getAllByHome(page,limit);
    }

    @ApiOperation("随机获取旅游路线")
    @GetMapping(value = "/app/unauth/findRandomVehicle")
    public ObjectRestResponse findRandomVehicle(Integer number) {
        return baseBiz.findRandomVehicle(number);
    }

}