package com.xxfc.platform.tour.mapper;

import com.xxfc.platform.tour.dto.TourUserScoreDetailDTO;
import com.xxfc.platform.tour.dto.TourUserScoreListDTO;
import com.xxfc.platform.tour.entity.TourUserScore;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 用户评分表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-21 20:27:43
 */
public interface TourUserScoreMapper extends Mapper<TourUserScore> {

    /**
     * 根据审核状态和车型id查询评论
     * @param goodId
     * @param status
     * @return
     */
    List<TourUserScoreListDTO> findyByGoodIdAndApproved(@Param("goodId") Integer goodId, @Param("status") Integer status);

    /**
     * 根据订单查询评价
     * @param orderId
     * @return
     */
    TourUserScoreDetailDTO findTourUserScoreDetailByOrderId(Integer orderId);
	
}
