package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户评分表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-21 20:27:43
 */
@Data
@Table(name = "tour_user_score")
public class TourUserScore implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	
	    /**
     *  商品id
     */
    @Column(name = "model_id")
	@ApiModelProperty(value = "商品id")
    private Integer modelId;
	
	    /**
     *  评分类型
     */
    @Column(name = "type")
	@ApiModelProperty(value = "评分类型")
    private Integer type;
	
	    /**
     *  评价分
     */
    @Column(name = "ave_score")
	@ApiModelProperty(value = "评价分")
    private Integer aveScore;
	
	    /**
     *  评分明细
     */
    @Column(name = "scores")
	@ApiModelProperty(value = "评分明细")
    private String scores;
	
	    /**
     *  是否匿名；0-否；1-是
     */
    @Column(name = "is_anony")
	@ApiModelProperty(value = "是否匿名；0-否；1-是")
    private Integer isAnony;
	
	    /**
     *  评价
     */
    @Column(name = "comment")
	@ApiModelProperty(value = "评价")
    private String comment;
	
	    /**
     *  图片
     */
    @Column(name = "imgs")
	@ApiModelProperty(value = "图片")
    private String imgs;
	
	    /**
     *  状态:0-未审核；1-已审核;2-审核不通过
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态:0-未审核；1-已审核;2-审核不通过")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除；0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;
	

}
