package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商品标签表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_good_tag")
public class TourGoodTag implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    //商品id
    @Column(name = "good_id")
	@ApiModelProperty(value = "商品id")
    private Integer goodId;
	
	    //标签id
    @Column(name = "tag_id")
	@ApiModelProperty(value = "标签id")
    private Integer tagId;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    //是否删除:0-正常；1-删除
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除:0-正常；1-删除")
    private Integer isDel;
	

}
