package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商品轮播图
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_good_banner")
public class TourGoodBanner implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //首页banner图主键
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("首页banner图主键")
    private Integer id;

	//商品id
	@Column(name = "good_id")
	@ApiModelProperty("商品id")
	private Integer goodId;
	
	    //标题
    @Column(name = "title")
	@ApiModelProperty(value = "标题")
    private String title;
	
	    //封面
    @Column(name = "cover")
	@ApiModelProperty(value = "封面")
    private String cover;
	
	    //创建人
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建人")
    private String crtName;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新人
    @Column(name = "upd_name")
	@ApiModelProperty(value = "更新人")
    private String updName;
	
	    //修改时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Long updTime;
	
	    //跳转链接
    @Column(name = "url")
	@ApiModelProperty(value = "跳转链接")
    private String url;
	
	    //是否删除，0否，1是
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;
	

}
