package com.xxfc.platform.tour.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 商品评分
 * @data 2019/6/18 15:15
 */
@Data
public class TourUserScoreDTO {


    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 订单id
     */
    @ApiModelProperty(value = "订单id")
    @NotNull(message = "订单id不能为空")
    private Integer orderId;

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    @NotNull(message = "商品id不能为空")
    private Integer modelId;

    /**
     *  评分类型
     */
    @ApiModelProperty(value = "评分类型")
    private Integer type;

    /**
     *  评价分
     */
    @ApiModelProperty(value = "评价分")
    private Integer aveScore;

    /**
     *  评分明细
     */
    @ApiModelProperty(value = "评分明细")
    private String scores;

    /**
     *  是否匿名；0-否；1-是
     */
    @ApiModelProperty(value = "是否匿名；0-否；1-是")
    private Integer isAnony;

    /**
     *  评价
     */
    @ApiModelProperty(value = "评价")
    private String comment;

    /**
     *  图片
     */
    @ApiModelProperty(value = "图片")
    private String imgs;

    /**
     *  状态:0-未审核；1-已审核;2-审核不通过
     */
    @ApiModelProperty(value = "状态:0-未审核；1-已审核;2-审核不通过")
    private Integer status;

    /**
     *  创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    /**
     *  更新时间
     */
    @ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

    /**
     *  是否删除；0-正常；1-删除
     */
    @ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;

    /**
     * 服务类型评分
     */
    @ApiModelProperty(value = "服务类型评分")
    private List<ScoreTypeDTO> scoretype;
}