package com.xxfc.platform.tour.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author libin
 * @version 1.0
 * @description banner
 * @data 2019/6/12 13:50
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TourTagBannerDTO {


    /**
     * 首页banner图主键
     */
    @ApiModelProperty("首页banner图主键")
    private Long id;

    /**
     * 标签id
     */
    @ApiModelProperty(value = "标签id")
    private Integer tagId;


    /**
     * 标题
     */
    @ApiModelProperty(value = "标题")
    private String title;

    /**
     * 封面
     */
    @ApiModelProperty(value = "封面")
    private String cover;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String crtName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updName;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间", hidden = true )
    private Long updTime;

    /**
     * 跳转链接
     */
    @ApiModelProperty(value = "跳转链接")
    private String url;

    /**
     * 是否删除，0否，1是
     */
    @ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;
}
