package com.xxfc.platform.tour.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 路线站点
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
public class GoodSiteDTO {


    private Integer id;
	
	    //路线id
	@ApiModelProperty(value = "路线id")
    private Integer goodId;
	
	//站点名称
	@ApiModelProperty(value = "站点名称")
    private String name;
	
	//站点地址
	@ApiModelProperty(value = "站点地址")
    private String address;

    //分公司id
	@ApiModelProperty(value = "分公司id")
	private Integer companyId;

	/**
	 * 地址-省/直辖市(编码)
	 */
	@ApiModelProperty("地址-省/直辖市(编码)")
	private Integer province;

	/**
	 * 地址-省/直辖市(名称)
	 */
	@ApiModelProperty("地址-省/直辖市(名称)")
	private String provinceName;

	/**
	 * 地址-市(编码)
	 */
	@ApiModelProperty("地址-市(编码)")
	private Integer city;

	/**
	 * 地址-市(名称)
	 */
	@ApiModelProperty("地址-市(名称)")
		private String cityName;

	//出发时间
	@ApiModelProperty(value = "出发时间")
    private Long departTime;
	
	//站点经度
	@ApiModelProperty(value = "站点经度")
    private Double longitude;
	
	//站点纬度
	@ApiModelProperty(value = "站点纬度")
    private Double latitude;
	
	//类型：0起点，1-途径点；2-终点
	@ApiModelProperty(value = "类型：0起点，1-途径点；2-终点")
    private Integer type;
	
	//排序
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	//状态 0正常 1关闭
	@ApiModelProperty(value = "状态 0正常 1关闭")
	private Integer status;

	//站点介绍
	@ApiModelProperty(value = "站点介绍")
    private String intro;
	

}
