package com.xxfc.platform.order.pojo.order;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import java.math.BigDecimal;

@Data
public class OrderTourVerificationVO {

    //基础订单id
    @ApiModelProperty(value = "基础订单id")
    private Integer orderId;

    //订单号
    @ApiModelProperty(value = "订单号")
    private String no;

    //订单类型 1--租车；2--旅游
    @ApiModelProperty(value = "订单类型 1--租车；2--旅游")
    private Integer type;

    //订单状态
    @ApiModelProperty(value = "订单状态\n" +
            "0--删除\n" +
            "1--创建订单\n" +
            "2--取消\n" +
            "3--待付款\n" +
            "4--待出行\n" +
            "5--出行中（进行中）\n" +
            "6--已完成")
    private Integer status;

    //实际价格
    @ApiModelProperty(value = "实际价格")
    private BigDecimal realAmount;

    //联系人
    @ApiModelProperty(value = "联系人")
    private String contactMan;


    //联系电话
    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    //总人数
    @ApiModelProperty(value = "总人数")
    private Integer totalNumber;

    //成人人数
    @ApiModelProperty(value = "成人人数")
    private Integer adultNum;

    //儿童人数
    @ApiModelProperty(value = "儿童人数")
    private Integer childNum;



}
