package com.xxfc.platform.order.pojo.order;

import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.order.pojo.DedDetailDTO;
import com.xxfc.platform.vehicle.entity.BookRecordUpdateLog;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderPageVO extends BaseOrder {
    public static final String TYPE = "type=";
    public static final String NO = "no=";

    OrderRentVehicleDetail orderRentVehicleDetail;

    OrderTourDetail orderTourDetail;

    OrderMemberDetail orderMemberDetail;

    List<VehicleUserLicense> vehicleUserLicenses;

    //更换还车公司记录
    List<BookRecordUpdateLog> bookRecordUpdateLogs;

    /**
     * 用户名
     */
    private String username;
    //用户姓名
    private String realName;

    private String startCompanyName;

    private String endCompanyName;

    private String telephone;

    //订单违约金
    private String dedDetailDTO;
    /**
     * 車輛編碼
     */
    private Integer code;

    /**
     * 是否是用户匹配公司
     */
    private boolean userCompanyStatus = false;

    /**
     * 车牌
     */
    private String vehicalNumberPlat;

    private String qrcodeStr;

    /**
     * 违章预备金
     */
    private BigDecimal illegalReserve;

    /**
     * 出交车记录
     */
    private OrderVehicleCrosstownDto orderVehicleCrosstownDto;

    private List<OrderItem> items;

    public void setQrcodeStr(String prefix) {
        this.qrcodeStr = prefix+ "?"+ TYPE+ getType()+ "&"+ NO+ getNo();
    }
}
