package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum OrderCostEnum {
    RENT_VEHICLE("01", "租车费用明细"),
    TOUR("02", "旅游费用明细"),
    CANCEL_NO_START("03", "取消违约金明细"),
    CANCEL_STARTED("04", "取消费用明细"),
    FINLISH_ADVANCE("05", "租车费用明细"),
    FINLISH_DELAY("06", "租车费用明细"),
    ;
    /**
     * 编码
     */
    private String code;

    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    OrderCostEnum(String code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}