package com.xxfc.platform.common.msg;

import lombok.Data;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/9 17:45
 */
@Data
public class PageApiResult<T> extends BaseApiResult<T> {

    private PageInfo pageInfo;

    private PageApiResult(long code, String msg, T data, boolean successResponse, String requestId, PageInfo pageInfo) {
        super(code, msg, data, successResponse, requestId);
        this.pageInfo = pageInfo;
    }

    public static <T> PageApiResult<T> ok() {
        return new PageApiResult(200, "ok", "ok", true, "0", PageInfo.createEmptyPageInfo());
    }

    public static <T> PageApiResult<T> ok(T data, PageInfo pageInfo) {
        return new PageApiResult(200, "ok", data, true, "0", pageInfo);
    }

    public static <T> PageApiResult<T> ok(T data, PageInfo pageInfo, String requestId) {
        return new PageApiResult(200, "ok", data, true, requestId, pageInfo);
    }

    @Data
    static class PageInfo {
        private Integer page;
        private Integer pageSize;
        private Integer total;

        private PageInfo(){}
        private PageInfo(Integer page, Integer pageSize, Integer total) {
            this.page = page;
            this.pageSize = pageSize;
            this.total = total;
        }

        public static PageInfo createEmptyPageInfo() {
            return new PageInfo();
        }
        public static PageInfo createPageInfo(Integer page, Integer pageSize, Integer total) {
             return new PageInfo(page,pageSize,total);
        }
    }
}
