package com.xxfc.platform.campsite.mapper;

import com.xxfc.platform.campsite.dto.CampsiteShopTagDTO;
import com.xxfc.platform.campsite.entity.CampsiteShopTag;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteShopTagMapper extends Mapper<CampsiteShopTag> {

    /**
     * 根据营地id查询
     * @param shopId
     * @return
     */
    List<CampsiteShopTagDTO> findAllByCampsiteShopId(Integer shopId);

    /**
     * 根据营地ids查询
     * @param campsiteShopIds
     * @return
     */
    List<CampsiteShopTagDTO> findAllByCampsiteShopIds(@Param("cspIds") List<Integer> campsiteShopIds);

    /**
     * 根据营地id 更新标签营地与类型对应的关系状态
     * @param ids
     * @param status
     * @param shopId
     * @return
     */
    int updateCampsiteTagStatusByIdsAndShopId(@Param("ids") List<Long> ids,@Param("status") Integer status, @Param("shopId") Integer shopId);

    /**
     * 批量保存营地与类型对应的关系
     * @param shopTagDTOS
     * @return
     */
    int saveBatch(@Param("stgdtos") List<CampsiteShopTagDTO> shopTagDTOS);

    /**
     * 根据营地id删除营地与类型对应的关系
     * @param shopId
     * @return
     */
    int deleteByShopId(Integer shopId);
}
