package com.xxfc.platform.campsite.mapper;

import com.xxfc.platform.campsite.dto.CampsiteShopCarouselDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopCarouselDetailDTO;
import com.xxfc.platform.campsite.entity.CampsiteShopCarousel;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 店铺轮播表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteShopCarouselMapper extends Mapper<CampsiteShopCarousel> {


    /**
     * 根据店铺id查询
     * @param shopId
     * @return
     */
    List<CampsiteShopCarouselDetailDTO> findAllCarousesByShopId(Integer shopId);

    /**
     * 根据营地id和轮播ids更新轮播状态
     * @param ids
     * @param shopId
     * @param status
     * @return
     */
    int updateCarouseStatusByIdsAndShopId(@Param("ids") List<Integer> ids, @Param("shopId") Integer shopId, @Param("status") int status);

    /**
     * 批量保存轮播信息
     * @param shopCarouselDTOS
     * @return
     */
    int saveBatch(@Param("sc") List<CampsiteShopCarouselDTO> shopCarouselDTOS);
}
