package com.xxfc.platform.campsite.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;


/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@ApiModel(value = "店铺类型vo")
public class CampsiteTagDTO implements Serializable {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 父id
     */
    @ApiModelProperty(value = "父id")
    private Integer parentId;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 是否筛选条件
     */
    @ApiModelProperty(value = "是否筛选条件")
    private Integer isSearch;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer rank;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Long ctrTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", hidden = true)
    private Long updTime;

    /**
     * 是否删除:0-正常；1-删除
     */
    @ApiModelProperty(value = "是否删除:0-正常；1-删除")
    private Integer isDel;

    @ApiModelProperty(value = "标签底图")
    private String tagUrl;
}
