package com.xxfc.platform.campsite.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;


/**
 * 营地店铺表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@ApiModel(value = "营地店铺dto" )
public class CampsiteShopDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 店铺名称
     */
    @ApiModelProperty(value = "店铺名称")
    private String name;

    /**
     * 店铺logo
     */
    @ApiModelProperty(value = "店铺logo")
    private String logo;

    /**
     * 店铺介绍
     */
    @ApiModelProperty(value = "店铺介绍")
    private String intro;

    /**
     * 店铺URL
     */
    @ApiModelProperty(value = "店铺URL")
    private String url;

    /**
     * 主要联系人
     */
    @ApiModelProperty(value = "主要联系人")
    private String concat;

    /**
     * 联系人身份证号
     */
    @ApiModelProperty(value = "联系人身份证号")
    private String idNumber;

    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    private String phone;

    /**
     * 公司id
     */
    @ApiModelProperty(value = "公司id")
    private Integer companyId;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    /**
     * 开店时间
     */
    @ApiModelProperty(value = "开店时间")
    private Long startTime;

    /**
     * 地址-省/直辖市(编码)
     */
    @ApiModelProperty(value = "地址-省/直辖市(编码)")
    private Integer province;

    /**
     * 地址-省/直辖市(名称)
     */
    @ApiModelProperty(value = "地址-省/直辖市(名称)")
    private String provinceName;

    /**
     * 地址-市
     */
    @ApiModelProperty(value = "地址-市")
    private Integer city;

    /**
     * 地址-市(名称)
     */
    @ApiModelProperty(value = "地址-市(名称)")
    private String cityName;

    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private Double longitude;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private Double latitude;

    /**
     * 具体地址
     */
    @ApiModelProperty(value = "具体地址")
    private String address;

    /**
     * 客服电话
     */
    @ApiModelProperty(value = "客服电话")
    private String servicePhone;

    /**
     * 配套设施&收费
     */
    @ApiModelProperty(value = "配套设施&收费")
    private String configure;

    /**
     * 店铺详情
     */
    @ApiModelProperty(value = "店铺详情")
    private String content;

    /**
     * 店铺状态:0-未开业；1-已开业
     */
    @ApiModelProperty(value = "店铺状态:0-未开业；1-已开业")
    private Integer status;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", hidden = true)
    private Long updTime;

    /**
     * 热度值
     */
    @ApiModelProperty(value = "热度值")
    private Integer hot;

}
