package com.xxfc.platform.app.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.app.biz.BannerBiz;
import com.xxfc.platform.app.entity.vo.BannerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/26 10:29
 */
@RestController
@RequestMapping("/banner")
public class BannerController {

    @Autowired
    private BannerBiz bannerBiz;

    /**
     * 查询banner图
     *
     * @return
     */
    @GetMapping("/app/unauth/findBannerlist")
    public ObjectRestResponse findBannerlist(@RequestParam(value = "type") Integer type,
                                             @RequestParam(required = false, value = "location") Integer location,
                                             @RequestParam(value = "platform",required = false,defaultValue = "0") Integer platform) {
        if (type == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        List<BannerVo> bannerList = bannerBiz.findBannerList(type, location,platform);
        return ObjectRestResponse.succ(bannerList);
    }
}
