package com.xxfc.platform.app.entity;

import java.io.Serializable;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 系统配置表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-03 15:57:13
 */
@Data
@Table(name = "config")
public class Cofig implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键id
	 */
	@Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;

	/**
	 * 1-租车须知；2-预定须知
	 */
    @Column(name = "type")
	@ApiModelProperty(value = "1-租车须知；2-预定须知;3-旅游")
    private Integer type;

	/**
	 *
	 */
	@Column(name = "value")
	@ApiModelProperty(value = "")
    private String value;

	/**
	 * 创建时间
	 */
	@Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

	/**
	 * 更新时间
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

	/**
	 * 是否删除；0-1正常；1-删除
	 */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-1正常；1-删除")
    private Integer isDel;

    @Column(name = "title")
	@ApiModelProperty(value = "标题")
    private String title;

    @Column(name = "params")
    private String params;
}
