package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityListBiz;
import com.xxfc.platform.activity.biz.HomeActivitiesBiz;
import com.xxfc.platform.activity.entity.ActivityList;
import com.xxfc.platform.activity.entity.HomeActivities;
import com.xxfc.platform.activity.vo.ActivitiesQuery;
import org.apache.ibatis.annotations.Delete;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 精彩活动
 * @author Administrator
 */
@RestController
@RequestMapping("homeActivities")
public class HomeActivitiesController extends BaseController<HomeActivitiesBiz, HomeActivities> {
    /**
     * app精彩活动列表
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @GetMapping("/app/unauth/activity/findAll")
    public ObjectRestResponse<List<HomeActivities>>  appFindAll()  {
        List<HomeActivities> list= baseBiz.activities();
        return ObjectRestResponse.succ(list);
    }

    /**
     * 后台精彩活动列表
     * @param query
     * @return
     */
    @PostMapping("manage/activity/findAll")
    public ObjectRestResponse findAll(@RequestBody  ActivitiesQuery query){
       return ObjectRestResponse.succ(baseBiz.getPage(query));
    }


    /**
     * 获取一条精彩活动
     * @param id
     * @return
     */
    @GetMapping(value = "/manage/activity/getOne/{id}")
    public ObjectRestResponse<HomeActivities> getOne(@PathVariable Integer id) {
        Example exa=new Example(HomeActivities.class);
        Example.Criteria criteria = exa.createCriteria();
        criteria.andEqualTo("isDel",0);
        criteria.andEqualTo("id",id);
        List<HomeActivities> homeActivities = baseBiz.selectByExample(exa);
        if (homeActivities==null||homeActivities.size()==0) {
            return ObjectRestResponse.succ(new HomeActivities());
        }
        if (homeActivities.size()>1) {
            return ObjectRestResponse.createDefaultFail();
        }
        return ObjectRestResponse.succ(homeActivities.get(0));
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @DeleteMapping("manage/activity/deleteOne/{id}")
    public ObjectRestResponse deleteOne(@PathVariable  Integer id){
        baseBiz.deleteOne(id);
        return ObjectRestResponse.succ();
    }

}