package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.CouponBiz;
import com.xxfc.platform.activity.entity.Coupon;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("coupon")
public class CouponController extends BaseController<CouponBiz, Coupon> {

    @ApiOperation("获取所用优惠卷")
    @GetMapping("/coupons")
    public Map<String, Coupon> coupons() {
        return baseBiz.getCoupons();
    }

    @ApiOperation("获取所用优惠卷")
    @GetMapping("/couponsBycouponIds")
    public List<Coupon> couponsBycouponIds(@RequestParam(value = "tickerNoList") List<String> tickerNoList) {
        return baseBiz.couponsByTickerNoList(tickerNoList);
    }

}