package com.xxfc.platform.activity.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;

@Table(name = "integral_rule")
@Data
public class IntegralRule{
    /**
     * 主键id
     */
    @Id
    private Integer id;

    /**
     * 周期单位:0-天,1-周；3-月；4-季；5-年
     */
    private Integer period;

    /**
     * 次数
     */
    private Integer number;

    /**
     * 积分
     */
    private Integer point;

    /**
     * 积分兑换:金额/分
     */
    private BigDecimal price;

    /**
     * 是否连续:0-不连续;1-连续
     */
    @Column(name = "is_continuity")
    private Boolean isContinuity;

    /**
     * 多少天后连续算
     */
    @Column(name = "finish_day")
    private Integer finishDay;

    /**
     * n天获取的积分
     */
    @Column(name = "finish_point")
    private Integer finishPoint;

    /**
     * 是否启用:1-启用；0-停用
     */
    private Boolean status;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;

    /**
     * 是否删除:0-正常；1-删除
     */
    private Boolean isdel;

    /**
     * 规则开始时间
     */
    @Column(name = "start_time")
    private Long startTime;

    /**
     * 规则结束时间
     */
    @Column(name = "end_time")
    private Long endTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 描述
     */
    private String detail;

    /**
     * 规则图片
     */
    private String img;

    /**
     * 排序
     */
    @Column(name = "order_id")
    private Integer orderId;

    /**
     * 规则名称
     */
    private String name;


    /**
     * 规则名称
     */
    private String code;

    /**
     * 获取积分规则 如：{"rule":4} 订单金额*4
     */
    private String regulation;

    /**
     * json字符串 如：[{"day":4,"integeral":8},{"day":4,"integeral":8}]
     */
    @Column(name = "other_rule")
    private String otherRule;

    /**
     * 操作按钮文字
     */
    private String btnWord;

    @Transient
    private Boolean integralStatus = false;

}