package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserAlipayBiz;
import com.github.wxiaoqi.security.admin.biz.MyWalletBiz;
import com.github.wxiaoqi.security.admin.vo.AppletWalletVo;
import com.github.wxiaoqi.security.admin.vo.ApplyCathVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:17
 */
@RestController
@RequestMapping("/wallet")
public class MyWalletController {


    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    private MyWalletBiz myWalletBiz;

    @Autowired
    private AppUserAlipayBiz alipayBiz;


     @GetMapping
    public ObjectRestResponse<AppletWalletVo> findMyWallet(HttpServletRequest request){
         try {
             IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
             AppletWalletVo wallet = myWalletBiz.findMyWallet(Integer.valueOf(infoFromToken.getId()));
             return ObjectRestResponse.succ(wallet);
         } catch (Exception e) {
             throw new BaseException(e);
         }

     }

    @GetMapping("/checkCode")
    @ApiOperation("检查验证码")
    public ObjectRestResponse  checkCode(
            @RequestParam(value = "phone",defaultValue = "")String phone,
            @RequestParam(value = "mobilecode",defaultValue = "")String mobilecod
     ){
        return   myWalletBiz.checkCode(phone,mobilecod);
     }

    @PostMapping("/setPwd")
    @ApiOperation("设置密码")
    public ObjectRestResponse  setPwd(
            @RequestParam(value = "phone",defaultValue = "")String phone,
            @RequestParam(value = "mobilecode",defaultValue = "")String mobilecod,
            @RequestParam(value = "password",defaultValue = "")String password,
            @RequestParam(value = "type",defaultValue = "1")Integer type,
            HttpServletRequest request){
         try {
             Integer userId=Integer.parseInt(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId());
             return   myWalletBiz.setPwd(userId,phone,mobilecod,password,type);
         }catch (Exception e) {
             throw new BaseException(e);
         }
    }

    @GetMapping("/checkSetPwd")
    @ApiOperation("检查用户是否设置过支付密码")
    public ObjectRestResponse  checkSetPwd(HttpServletRequest request){
        try {
            Integer userId=Integer.parseInt(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId());
            return   myWalletBiz.checkSetPwd(userId);
        }catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @GetMapping("/checkAmount")
    @ApiOperation("检查提成下一步操作")
    public ObjectRestResponse  checkAmount(
            @RequestParam(value = "amount",defaultValue = "0.00") BigDecimal amount,
            HttpServletRequest request){
        try {
            Integer userId=Integer.parseInt(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId());
            return   myWalletBiz.checkAmount(userId,amount,null);
        }catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @PostMapping("/applyCath")
    @ApiOperation("提现申请")
    public ObjectRestResponse  applyCath(@RequestBody ApplyCathVo applyCathVo, HttpServletRequest request){
        try {
            Integer userId=Integer.parseInt(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId());
            applyCathVo.setUserId(userId);
            return   myWalletBiz.applyCath(applyCathVo);
        }catch (Exception e) {
            throw new BaseException(e);
        }
    }



    @GetMapping("/txAlipayList")
    @ApiOperation("获取支付账号列表")
    public ObjectRestResponse  txAlipayList(HttpServletRequest request){
        try {
            Integer userId=Integer.parseInt(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId());
            return  ObjectRestResponse.succ(alipayBiz.getListByUserId(userId)) ;
        }catch (Exception e) {
            throw new BaseException(e);
        }
    }

}
