package com.github.wxiaoqi.security.admin.config;

import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;
/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitAdminConfig extends RabbitCommonConfig {

    public static final String ORDER_WATER_QUEUE = "order.water.queue";

    public static final String ORDER_FINLISH_USER_RE_QUEUE = "order.cancel.userRe.queue";
    //钱包50入账
    public static final String  WALLET_ADD_QUEUE = "wallet.add.queue";

    //支付完成后永久绑定关系
    public static final String ORDER_RELATION_QUEUE = "order.relation.queue";
    static {
            myQueue = new ArrayList<BindDTO>(){{
            //支付完成后永久绑定关系
            add(new BindDTO(ORDER_RELATION_QUEUE, ORDER_TOPIC, KEY_ORDER_PAY));
            //拥金计算
            add(new BindDTO(ORDER_WATER_QUEUE, ORDER_TOPIC, KEY_ORDER_PAY));
            add(new BindDTO(ORDER_WATER_QUEUE, ORDER_TOPIC, KEY_ORDER_FINLISH));
            add(new BindDTO(ORDER_WATER_QUEUE, ORDER_TOPIC, KEY_ORDER_CANCEL));
            add(new BindDTO(ORDER_FINLISH_USER_RE_QUEUE,  ORDER_TOPIC, KEY_ORDER_FINLISH));
            //钱包
            add(new BindDTO(WALLET_ADD_QUEUE,  ADMIN_TOPIC, KEY_WALLET_ADD));
        }};
    }
}

