package com.github.wxiaoqi.security.admin.vo;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/15 9:22
 */
@Data
public class WalletDetailPageVo {


    @ApiModelProperty("主键ID")
    private Integer id;

    /**
     *  来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买
     */
    @ApiModelProperty(value = "来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买")
    private Integer source;

    /**
     *  收入/支出：0-收入，1-支出
     */
    @ApiModelProperty(value = "收入/支出：0-收入，1-支出")
    private Integer itype;

    /**
     *  收入/支出的金额(分)
     */
    @ApiModelProperty(value = "收入/支出的金额(分)")
    private BigDecimal amount;

    /**
     *  操作时间
     */
    @ApiModelProperty(value = "操作时间", hidden = true )
    private Long crtTime;

    @ApiModelProperty("描述")
    private String desc;

}
