package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/11 15:14
 */
@Data
public class AppUserSellingWaterDTO {
    /**
     *  用户id
     */
    @ApiModelProperty(value = "用户id")
    private Integer userId;

    /**
     *  身份职位
     */
    @ApiModelProperty(value = "身份职位")
    private Integer positionId;

    /**
     *  来源用户id
     */
    @ApiModelProperty(value = "来源用户id")
    private Integer sourceId;

    /**
     *  订单id
     */
    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    /**
     *  商品id
     */
    @ApiModelProperty(value = "商品id")
    private Integer goodId;

    /**
     *  商品数量
     */
    @ApiModelProperty(value = "商品数量")
    private Integer goodNumber;

    /**
     *  类型 1=>一级上线提成
     */
    @ApiModelProperty(value = "类型 1=>一级上线提成")
    private Integer type;

    /**
     *  类别：0-正；1-负
     */
    @ApiModelProperty(value = "类别：0-正；1-负")
    private Integer status;

    /**
     *  商品标题
     */
    @ApiModelProperty(value = "商品标题")
    private String title;

    /**
     *  图片
     */
    @ApiModelProperty(value = "图片")
    private String img;

    /**
     *  售价
     */
    @ApiModelProperty(value = "售价")
    private Long price;

    /**
     *  提成百分比
     */
    @ApiModelProperty(value = "提成百分比")
    private Integer extract;

    /**
     *  是否入账：0-未入账；1-已入账
     */
    @ApiModelProperty(value = "是否入账：0-未入账；1-已入账")
    private Integer waiting;

}
