/*
 * Decompiled with CFR 0.152.
 */
package com.cloopen.rest.sdk;

import com.cloopen.rest.sdk.utils.CcopHttpClient;
import com.cloopen.rest.sdk.utils.DateUtil;
import com.cloopen.rest.sdk.utils.EncryptUtil;
import com.cloopen.rest.sdk.utils.LoggerUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import ytx.org.apache.http.HttpEntity;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.client.methods.HttpGet;
import ytx.org.apache.http.client.methods.HttpPost;
import ytx.org.apache.http.client.methods.HttpRequestBase;
import ytx.org.apache.http.entity.BasicHttpEntity;
import ytx.org.apache.http.impl.client.DefaultHttpClient;
import ytx.org.apache.http.message.AbstractHttpMessage;
import ytx.org.apache.http.util.EntityUtils;

public class CCPRestSmsSDK {
    private static final int Request_Get = 0;
    private static final int Request_Post = 1;
    private static final String TemplateSMS = "SMS/TemplateSMS";
    private String SERVER_IP;
    private String SERVER_PORT;
    private String ACCOUNT_SID;
    private String ACCOUNT_TOKEN;
    public String App_ID;
    private BodyType BODY_TYPE = BodyType.Type_JSON;

    public void init(String serverIP, String serverPort) {
        if (this.isEmpty(serverIP) || this.isEmpty(serverPort)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:serverIP\u6216serverPort\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(serverIP) ? " \u670d\u52a1\u5668\u5730\u5740 " : "") + (this.isEmpty(serverPort) ? " \u670d\u52a1\u5668\u7aef\u53e3 " : "") + "\u4e3a\u7a7a");
        }
        this.SERVER_IP = serverIP;
        this.SERVER_PORT = serverPort;
    }

    public void setAccount(String accountSid, String accountToken) {
        if (this.isEmpty(accountSid) || this.isEmpty(accountToken)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:accountSid\u6216accountToken\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(accountSid) ? " \u4e3b\u5e10\u53f7\u540d\u79f0" : "") + (this.isEmpty(accountToken) ? " \u4e3b\u5e10\u53f7\u4ee4\u724c " : "") + "\u4e3a\u7a7a");
        }
        this.ACCOUNT_SID = accountSid;
        this.ACCOUNT_TOKEN = accountToken;
    }

    public void setAppId(String appId) {
        if (this.isEmpty(appId)) {
            LoggerUtil.fatal("\u521d\u59cb\u5316\u5f02\u5e38:appId\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5e94\u7528Id \u4e3a\u7a7a");
        }
        this.App_ID = appId;
    }

    public HashMap<String, Object> sendTemplateSMS(String to, String templateId, String[] datas) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(to) || this.isEmpty(this.App_ID) || this.isEmpty(templateId)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u624b\u673a\u53f7\u7801 " : "") + (this.isEmpty(templateId) ? " \u6a21\u677fId " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            try {
                HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, TemplateSMS);
                String requsetbody = "";
                if (this.BODY_TYPE == BodyType.Type_JSON) {
                    JsonObject json = new JsonObject();
                    json.addProperty("appId", this.App_ID);
                    json.addProperty("to", to);
                    json.addProperty("templateId", templateId);
                    if (datas != null) {
                        StringBuilder sb = new StringBuilder("[");
                        String[] stringArray = datas;
                        int n = datas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            sb.append("\"" + s + "\"" + ",");
                            ++n2;
                        }
                        sb.replace(sb.length() - 1, sb.length(), "]");
                        JsonParser parser = new JsonParser();
                        JsonArray Jarray = parser.parse(sb.toString()).getAsJsonArray();
                        json.add("datas", Jarray);
                    }
                    requsetbody = json.toString();
                } else {
                    StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><TemplateSMS>");
                    sb.append("<appId>").append(this.App_ID).append("</appId>").append("<to>").append(to).append("</to>").append("<templateId>").append(templateId).append("</templateId>");
                    if (datas != null) {
                        sb.append("<datas>");
                        String[] stringArray = datas;
                        int n = datas.length;
                        int parser = 0;
                        while (parser < n) {
                            String s = stringArray[parser];
                            sb.append("<data>").append(s).append("</data>");
                            ++parser;
                        }
                        sb.append("</datas>");
                    }
                    sb.append("</TemplateSMS>").toString();
                    requsetbody = sb.toString();
                }
                LoggerUtil.info("sendTemplateSMS Request body =  " + requsetbody);
                BasicHttpEntity requestBody = new BasicHttpEntity();
                requestBody.setContent(new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
                requestBody.setContentLength(requsetbody.getBytes("UTF-8").length);
                httppost.setEntity(requestBody);
                HttpResponse response = httpclient.execute(httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString(entity, "UTF-8");
                }
                EntityUtils.consume(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                LoggerUtil.error(e.getMessage());
                HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
                if (httpclient != null) {
                    httpclient.getConnectionManager().shutdown();
                }
                return hashMap;
            }
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        LoggerUtil.info("sendTemplateSMS response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * Unable to fully structure code
     */
    private HashMap<String, Object> jsonToMap(String result) {
        hashMap = new HashMap<String, Object>();
        parser = new JsonParser();
        asJsonObject = parser.parse(result).getAsJsonObject();
        entrySet = asJsonObject.entrySet();
        hashMap2 = new HashMap<String, Object>();
        for (Map.Entry<String, JsonElement> m : entrySet) {
            if ("statusCode".equals(m.getKey()) || "statusMsg".equals(m.getKey())) {
                hashMap.put(m.getKey(), m.getValue().getAsString());
                continue;
            }
            if ("SubAccount".equals(m.getKey()) || "totalCount".equals(m.getKey()) || "token".equals(m.getKey()) || "downUrl".equals(m.getKey())) {
                block15: {
                    if (!"SubAccount".equals(m.getKey())) {
                        hashMap2.put(m.getKey(), m.getValue().getAsString());
                    } else {
                        try {
                            if (m.getValue().toString().trim().length() <= 2 && !m.getValue().toString().contains("[")) {
                                hashMap2.put(m.getKey(), m.getValue().getAsString());
                                hashMap.put("data", hashMap2);
                                break;
                            }
                            if (m.getValue().toString().contains("[]")) {
                                hashMap2.put(m.getKey(), new JsonArray());
                                hashMap.put("data", hashMap2);
                                continue;
                            }
                            asJsonArray = parser.parse(m.getValue().toString()).getAsJsonArray();
                            arrayList = new ArrayList<HashMap<K, V>>();
                            for (JsonElement j : asJsonArray) {
                                entrySet2 = j.getAsJsonObject().entrySet();
                                hashMap3 = new HashMap<String, String>();
                                for (Map.Entry<String, JsonElement> m2 : entrySet2) {
                                    hashMap3.put(m2.getKey(), m2.getValue().getAsString());
                                }
                                arrayList.add(hashMap3);
                            }
                            hashMap2.put("SubAccount", arrayList);
                            break block15;
                        }
                        catch (Exception e) {
                            asJsonObject2 = parser.parse(m.getValue().toString()).getAsJsonObject();
                            entrySet2 = asJsonObject2.entrySet();
                            hashMap3 = new HashMap<String, String>();
                            ** for (m2 : entrySet2)
                        }
lbl-1000:
                        // 1 sources

                        {
                            hashMap3.put(m2.getKey(), m2.getValue().getAsString());
                            continue;
                        }
lbl52:
                        // 1 sources

                        hashMap2.put(m.getKey(), hashMap3);
                        hashMap.put("data", hashMap2);
                    }
                }
                hashMap.put("data", hashMap2);
                continue;
            }
            asJsonObject2 = parser.parse(m.getValue().toString()).getAsJsonObject();
            entrySet2 = asJsonObject2.entrySet();
            hashMap3 = new HashMap<String, String>();
            for (Map.Entry<String, JsonElement> m2 : entrySet2) {
                hashMap3.put(m2.getKey(), m2.getValue().getAsString());
            }
            if (hashMap3.size() != 0) {
                hashMap2.put(m.getKey(), hashMap3);
            } else {
                hashMap2.put(m.getKey(), m.getValue().getAsString());
            }
            hashMap.put("data", hashMap2);
        }
        return hashMap;
    }

    private HashMap<String, Object> xmlToMap(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText(xml);
            Element rootElt = doc.getRootElement();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Iterator i = rootElt.elementIterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if ("statusCode".equals(e.getName()) || "statusMsg".equals(e.getName())) {
                    map.put(e.getName(), e.getText());
                    continue;
                }
                if ("SubAccount".equals(e.getName()) || "totalCount".equals(e.getName()) || "token".equals(e.getName()) || "downUrl".equals(e.getName())) {
                    if (!"SubAccount".equals(e.getName())) {
                        hashMap2.put(e.getName(), e.getText());
                    } else {
                        ArrayList arrayList = new ArrayList();
                        HashMap<String, String> hashMap3 = new HashMap<String, String>();
                        Iterator i2 = e.elementIterator();
                        while (i2.hasNext()) {
                            Element e2 = (Element)i2.next();
                            hashMap3.put(e2.getName(), e2.getText());
                            arrayList.add(hashMap3);
                        }
                        hashMap2.put("SubAccount", arrayList);
                    }
                    map.put("data", hashMap2);
                    continue;
                }
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                Iterator i2 = e.elementIterator();
                while (i2.hasNext()) {
                    Element e2 = (Element)i2.next();
                    hashMap3.put(e2.getName(), e2.getText());
                }
                if (hashMap3.size() != 0) {
                    hashMap2.put(e.getName(), hashMap3);
                } else {
                    hashMap2.put(e.getName(), e.getText());
                }
                map.put("data", hashMap2);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
        }
        catch (Exception e) {
            LoggerUtil.error(e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    private HttpRequestBase getHttpRequestBase(int get, String action) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String timestamp = DateUtil.dateToStr(new Date(), 5);
        EncryptUtil eu = new EncryptUtil();
        String sig = "";
        String acountName = "";
        String acountType = "Accounts";
        acountName = this.ACCOUNT_SID;
        sig = String.valueOf(this.ACCOUNT_SID) + this.ACCOUNT_TOKEN + timestamp;
        String signature = eu.md5Digest(sig);
        String url = this.getBaseUrl().append("/" + acountType + "/").append(acountName).append("/" + action + "?sig=").append(signature).toString();
        LoggerUtil.info(String.valueOf(this.getmethodName(action)) + " url = " + url);
        HttpRequestBase mHttpRequestBase = null;
        if (get == 0) {
            mHttpRequestBase = new HttpGet(url);
        } else if (get == 1) {
            mHttpRequestBase = new HttpPost(url);
        }
        this.setHttpHeader(mHttpRequestBase);
        String src = String.valueOf(acountName) + ":" + timestamp;
        String auth = eu.base64Encoder(src);
        mHttpRequestBase.setHeader("Authorization", auth);
        return mHttpRequestBase;
    }

    private String getmethodName(String action) {
        if (action.equals(TemplateSMS)) {
            return "sendTemplateSMS";
        }
        return "";
    }

    private void setHttpHeader(AbstractHttpMessage httpMessage) {
        if (this.BODY_TYPE == BodyType.Type_JSON) {
            httpMessage.setHeader("Accept", "application/json");
            httpMessage.setHeader("Content-Type", "application/json;charset=utf-8");
        } else {
            httpMessage.setHeader("Accept", "application/xml");
            httpMessage.setHeader("Content-Type", "application/xml;charset=utf-8");
        }
    }

    private StringBuffer getBaseUrl() {
        StringBuffer sb = new StringBuffer("https://");
        sb.append(this.SERVER_IP).append(":").append(this.SERVER_PORT);
        sb.append("/2013-12-26");
        return sb;
    }

    private boolean isEmpty(String str) {
        return "".equals(str) || str == null;
    }

    private HashMap<String, Object> getMyError(String code, String msg) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("statusCode", code);
        hashMap.put("statusMsg", msg);
        return hashMap;
    }

    private HashMap<String, Object> accountValidate() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7\u4ee4\u724c\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.App_ID)) {
            return this.getMyError("172012", "\u5e94\u7528ID\u4e3a\u7a7a");
        }
        return null;
    }

    public static enum AccountType {
        Accounts,
        SubAccounts;

    }

    public static enum BodyType {
        Type_XML,
        Type_JSON;

    }
}

