package com.xxfc.platform.activity.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.activity.entity.ActivityList;
import com.xxfc.platform.activity.entity.ActivityManagement;
import com.xxfc.platform.activity.mapper.ActivityManagementMapper;
import com.xxfc.platform.activity.vo.ActivityManagementQuery;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@Service
public class ActivityManagementBiz extends BaseBiz<ActivityManagementMapper, ActivityManagement> {

    @Autowired
    private ActivityListBiz activityListBiz;

    /**
     * 查询所有活动
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     * @param query
     */
    public PageInfo<ActivityList> selectedActivityManagement(ActivityManagementQuery query) throws InvocationTargetException, IllegalAccessException {

        PageHelper.startPage(query.getPage(),query.getLimit());
        List<ActivityList> activityLists = activityListBiz.selectListAll();
        return PageInfo.of(activityLists);
    }



    /**
     * 根据活动id获取活动详情
     * @param activityId
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    public Object getOne(Integer activityId) throws InvocationTargetException, IllegalAccessException {
        ActivityList activityList = activityListBiz.selectById(activityId);
        ActivityManagement activityManagement = getActivityManagement(activityList);
        return activityManagement;
    }


    /**
     * cope bean
     * @param m
     * @param <M>
     * @param <V>
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private  <M,V> ActivityManagement getActivityManagement(M m) throws InvocationTargetException, IllegalAccessException {
        ActivityManagement activityManagement = new ActivityManagement();
        BeanUtilsBean.getInstance().copyProperties(activityManagement,m);
        return activityManagement;
    }


    /**
     * 修改活动
     * @param activityManagement
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateActivityManagement(ActivityManagement activityManagement) throws InvocationTargetException, IllegalAccessException {
        ActivityList activityList= new ActivityList();
        BeanUtilsBean.getInstance().copyProperties(activityList,activityManagement);
        activityListBiz.updateSelectiveByIdRe(activityList);
    }
}
