package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.MyWalletCathBiz;
import com.github.wxiaoqi.security.admin.vo.WalletCathDetailVo;
import com.github.wxiaoqi.security.admin.vo.WalletCathPageVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 14:17
 */
@RestController
@RequestMapping("/walletcath")
public class WalletCathController {

    @Autowired
    private MyWalletCathBiz myWalletCathBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @ApiOperation("提现记录列表")
    @GetMapping("/page")
    public ObjectRestResponse<WalletCathPageVo> findWatchCatchByWithdrawalState(@RequestParam("state") Integer state,
                                                                                @RequestParam("pageNo") Integer pageNo,
                                                                                @RequestParam("pageSize") Integer pageSize,
                                                                                HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            WalletCathPageVo catchByWithdrawa = myWalletCathBiz.findWatchCatchByWithdrawalState(Integer.valueOf(infoFromToken.getId()), state, pageNo, pageSize);
            return ObjectRestResponse.succ(catchByWithdrawa);
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @ApiOperation("提现详情")
    @GetMapping("/detail/{id}")
    public ObjectRestResponse<WalletCathDetailVo> getWalletCathDetailById(@PathVariable(value = "id") Long id) {
        WalletCathDetailVo walletCathDetailVo = myWalletCathBiz.getWalletCathDetailById(id);
        return ObjectRestResponse.succ(walletCathDetailVo);
    }
}
