package com.github.wxiaoqi.security.admin.feign.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;

import javax.servlet.http.HttpServletRequest;

public interface UserRestInterface {
    public UserFeign getUserFeign();

    public HttpServletRequest getRequest();

    default AppUserDTO getAppUser(){
        return  getUserFeign().userDetailByToken(BaseContextHandler.getToken()).getData();
    }

    default void checkAppUser(){
        if(null == getAppUser()) {
            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
        }
    }
}
