package com.xxfc.platform.vehicle.jobhandler;


import com.xxfc.platform.vehicle.biz.VehicleApplyBiz;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/1 11:28
 */
@JobHandler(value = "vehicleApplyhandler")
@Component("vehicleApplyhandler")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class VehicleApplyJobHandler extends IJobHandler {

       private final VehicleApplyBiz vehicleApplyBiz;


    @Override
    public ReturnT<String> execute(String s) throws Exception {
        try {
            vehicleApplyBiz.authAudit();
            return ReturnT.SUCCESS;
        } catch (Exception ex) {
            XxlJobLogger.log(ex);
            return FAIL;
        }
    }
}
