package com.xxfc.platform.user.behavior.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.user.behavior.biz.CustomerBehaviorNotesBiz;
import com.xxfc.platform.user.behavior.vo.BehaviorNoteCollectVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 用户行为日志*后台统计
 * @data 2019/8/12 15:16
 */
@RestController
@RequestMapping("/admin/customerBehaviorNotes")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CustomerBehaviorNotesAdminController {

    private final CustomerBehaviorNotesBiz customerBehaviorNotesBiz;

    @GetMapping("/collect/{activityId}")
    public ObjectRestResponse<List<BehaviorNoteCollectVo>> findCollectByActivityId(@PathVariable(value = "activityId") Integer activityId,
                                                                                   @RequestParam(value = "startTime", required = false) Long startTime,
                                                                                   @RequestParam(value = "endTime", required = false) Long endTime) {
        List<BehaviorNoteCollectVo> behaviorNoteCollectVos = customerBehaviorNotesBiz.findBehaviorCollectByActivityId(activityId, startTime, endTime);
        return ObjectRestResponse.succ(behaviorNoteCollectVos);
    }
}
