package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityProductSpecsBiz;
import com.xxfc.platform.activity.entity.ActivityProductSpecs;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/activity/specs")
public class ActivityProductSpecsController extends BaseController<ActivityProductSpecsBiz, ActivityProductSpecs> {

	@PostMapping(value = "/app/unauth/add")
	public ObjectRestResponse add(@RequestBody ActivityProductSpecs activityProductSpecs) {
		return baseBiz.add(activityProductSpecs);
	}

	@GetMapping(value = "/app/unauth/get")
	public ObjectRestResponse<ActivityProductSpecs> get(Long id) {
		return ObjectRestResponse.succ(baseBiz.getOne(id));
	}

	@GetMapping(value = "/app/unauth/getAllByActivityId")
	public ObjectRestResponse getAllByActiveId(Long activityId) {
		return ObjectRestResponse.succ(baseBiz.getAllByActiveId(activityId));
	}

	@PostMapping(value = "/app/unauth/update")
	public ObjectRestResponse update(@RequestBody ActivityProductSpecs activityProductSpecs) {
		return baseBiz.update(activityProductSpecs);
	}
}
