package com.xxfc.platform.activity.biz;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.entity.IntegralUserRecord;
import com.xxfc.platform.activity.mapper.IntegralUserRecordMapper;
import com.xxfc.platform.activity.user.UserInfoBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Slf4j
public class IntegralUserRecordBiz extends BaseBiz<IntegralUserRecordMapper, IntegralUserRecord> {

        @Autowired
        UserInfoBiz userInfoBiz;

    /**
     * 添加用户积分记录
     * @param integralUserRecord
     * @return
     */
        public ObjectRestResponse add(IntegralUserRecord integralUserRecord) {
                return ObjectRestResponse.succ();
            }

        /**
         * 删除一个用户记录
         * @param id
         * @return
         */
        public ObjectRestResponse deleteOne(Integer id) {
             if(id == null || id <=0 ) {
                    return ObjectRestResponse.paramIsEmpty();
             }
             IntegralUserRecord integralUserRecord = mapper.selectByPrimaryKey(id);
             if(integralUserRecord == null) {
                 log.info("删除的用户记录不存在，要删除的id ={}", id);
                 return ObjectRestResponse.createDefaultFail();
             }
             integralUserRecord.setIsdel(true);
             mapper.updateByPrimaryKeySelective(integralUserRecord);
             return ObjectRestResponse.succ();
        }

        /**
         *  根据获取某个用户的列表
         * @return
         */
        public ObjectRestResponse<IntegralUserRecord> getUserList() {
            AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
            if (appUserDTO == null) {
                return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
            }
            return ObjectRestResponse.succ();
        }

}
