package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum VehicleBookRecordStatus {
    APPLY(1,"申请中"),
    APPROVE(2,"已通过"),
    RETURNED(3,"已归还"),
    REJECTED(4,"拒绝"),
    RETURNED_OUT_DATE(5,"逾期归还"),
    CANCEL_APPLY(6,"取消预订"),
    LIFTED(7,"已提车"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(VehicleBookRecordStatus constantType : VehicleBookRecordStatus.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    VehicleBookRecordStatus(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
