package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.dto.BaseUserMemberVO;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.InvocationTargetException;

/**
 * 用户会员
 * @author Administrator
 */
@RestController
@RequestMapping("baseUserMember")
public class BaseUserMemberController extends BaseController<BaseUserMemberBiz, BaseUserMember> {
    @RequestMapping("/findOne/{userId}")
    public ObjectRestResponse<AppUserManage> findOneByUserId(@PathVariable Integer userId){
        BaseUserMember oneByUserId = baseBiz.findOneByUserId(userId);
        if (oneByUserId==null) {
            return ObjectRestResponse.succ();
        }
        return  ObjectRestResponse.succ(oneByUserId);
    }



    /**
     * 设置用户会员
     * @param baseUserMemberVO
     * @return
     */
    @PostMapping("/setUserMember")
    public ObjectRestResponse setUserMember(@RequestBody BaseUserMemberVO baseUserMemberVO)
            throws InvocationTargetException, IllegalAccessException {
        baseBiz.setUserMember(baseUserMemberVO);
        return ObjectRestResponse.succ();
    }
}
