package com.github.wxiaoqi.security.admin.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.wxiaoqi.security.admin.entity.AppUserRelationTemp;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import com.github.wxiaoqi.security.admin.mapper.AppUserRelationMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

/**
 * 用户关系表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-03 16:36:44
 */
@Service
public class AppUserRelationBiz extends BaseBiz<AppUserRelationMapper,AppUserRelation> {

    @Autowired
    AppUserRelationTempBiz relationTempBiz;

    @Autowired
    AppUserDetailBiz userDetailBiz;

    /**
     * 关系绑定
     * @param userId
     * @param parentId
     */
    public   void bindRelation(Integer userId,Integer parentId){
        AppUserRelation relation=getMyBiz().getRelationByUserId(parentId);
         if(relation==null){
             relation=new AppUserRelation();
             relation.setUserId(parentId);
             insertSelective(relation);
         }
        relation=getMyBiz().getRelationByUserId(userId);
        Long time=System.currentTimeMillis();
         if(relation==null){
             relation=new AppUserRelation();
             relation.setUserId(userId);
             relation.setParentId(parentId);
             relation.setBindType(2);
             relation.setBindTime(time);
             insertSelective(relation);
         }else {
             if(relation.getParentId()==null||relation.getParentId()==0||(relation.getIsForever()!=1&&(time-relation.getBindTime())>3600)){
                 relation.setParentId(parentId);
                 relation.setBindType(2);
                 relation.setBindTime(time);
                getMyBiz().updRelation(relation);
             }
         }
    }

    /**
     * 小程序分享上下线绑定
     * @param userid  当前人小程序id
     * @param pid  分享人id
     * @param platform_userid  当前人统一平台id
     */
    public ObjectRestResponse shareParentByUserId(Integer userid, Integer pid, Integer platform_userid){
        if(pid==null||pid==0||((platform_userid==null||platform_userid==0)&&(userid==0||userid==null))){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        if(platform_userid==null||platform_userid==0){
            upRelationTemp(pid,userid);
        }else {
            AppUserVo userVo=userDetailBiz.getUserInfoById(platform_userid);
            if(userVo==null){
                upRelationTemp(pid,userid);
            }else {
                bindRelation(platform_userid,pid);
            }
        }
        return ObjectRestResponse.succ();

    }

    /**
     * 新增临时关系
     * @param pid
     * @param userid
     */
    public  void upRelationTemp(Integer pid,Integer userid){

        AppUserRelationTemp relationTemp=new AppUserRelationTemp();
        relationTemp.setUserId(pid);
        relationTemp.setIsDel(0);
        relationTemp.setType(1);
        AppUserRelationTemp relationTemp1= relationTempBiz.selectOne(relationTemp);
        if(relationTemp1==null){
            relationTemp.setTempId(userid);
            relationTempBiz.insertSelective(relationTemp);
        }

    }

    /**
     * 小程序上下线绑定
     * @param platform_userid 当前人统一平台id
     * @param userid 当前人小程序id
     */
    public void bindByUserId(Integer platform_userid,Integer userid){
        if(platform_userid==null||platform_userid==0||userid==null||userid==0){
            return;
        }
        AppUserRelationTemp relationTemp =new AppUserRelationTemp();
        relationTemp.setTempId(userid);
        relationTemp.setIsValid(0);
        relationTemp.setType(1);
        relationTemp.setIsDel(0);
        relationTemp=relationTempBiz.selectOne(relationTemp);
        if(relationTemp==null){
           return;
        }
        Integer parentId=relationTemp.getUserId();
        bindRelation(platform_userid,parentId);

    }

    /**
     * 获取用户的上线关系
     * @param userId
     * @return
     */
    @Cache(key="user:relation{1}")
    public  AppUserRelation getRelationByUserId(Integer userId){
        AppUserRelation relation=new AppUserRelation();
        relation.setUserId(userId);
        return  selectOne(relation);
    }

     @CacheClear(key="user:relation{1.userId}")
    public  int  updRelation(AppUserRelation appUserRelation){
       return super.updateSelectiveByIdRe(appUserRelation);
    }

    private AppUserRelationBiz getMyBiz() {
        return AopContext.currentProxy() != null ? (AppUserRelationBiz) AopContext.currentProxy() : this;
    }
}