package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import tk.mybatis.mapper.annotation.Version;


/**
 *
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-15 11:35:33
 */
@Data
@Table(name = "base_order")
public class BaseOrder implements Serializable {
	private static final long serialVersionUID = 1L;

	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;

	    /**
     *  订单号
     */
    @Column(name = "no")
	@ApiModelProperty(value = "订单号")
    private String no;

	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;

	    /**
     *  订单类型 1--租车；2--旅游
     */
    @Column(name = "type")
	@ApiModelProperty(value = "订单类型 1--租车；2--旅游; 3--会员订单")
    private Integer type;

	    /**
     *  订单详情id
     */
    @Column(name = "detail_id")
	@ApiModelProperty(value = "订单详情id")
    private Integer detailId;

    @Column(name = "status")
	@ApiModelProperty(value = "订单状态"
+"0--删除"
+"1--创建订单"
+"2--取消"
+"3--待付款"
+"4--待出行"
+"5--出行中（进行中）"
+"6--已完成")
    private Integer status;

	    /**
     *  商品价格
     */
    @Column(name = "goods_amount")
	@ApiModelProperty(value = "商品价格")
    private BigDecimal goodsAmount;

	    /**
     *  订单价格
     */
    @Column(name = "order_amount")
	@ApiModelProperty(value = "订单价格")
    private BigDecimal orderAmount;

	    /**
     *  实际价格
     */
    @Column(name = "real_amount")
	@ApiModelProperty(value = "实际价格")
    private BigDecimal realAmount;

	    /**
     *  第三方类型（支付渠道）
     */
    @Column(name = "third_type")
	@ApiModelProperty(value = "第三方类型（支付渠道）")
    private Integer thirdType;

	    /**
     *  流水号
     */
    @Column(name = "out_trade_no")
	@ApiModelProperty(value = "流水号")
    private String outTradeNo;

	    /**
     *  订单图片
     */
    @Column(name = "picture")
	@ApiModelProperty(value = "订单图片")
    private String picture;

	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;

	    /**
     *  创建者id
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private String crtUser;

	    /**
     *  创建者名称
     */
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建者名称")
    private String crtName;

	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;

	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;

	    /**
     *  创建者ip
     */
    @Column(name = "crt_host")
	@ApiModelProperty(value = "创建者ip")
    private String crtHost;

	    /**
     *  取消原因
     */
    @Column(name = "cancel_reason")
	@ApiModelProperty(value = "取消原因")
    private String cancelReason;

	    /**
     *  退款流水号
     */
    @Column(name = "refund_trade_no")
	@ApiModelProperty(value = "退款流水号")
    private String refundTradeNo;

	    /**
     *  支付时间
     */
    @Column(name = "pay_time")
	@ApiModelProperty(value = "支付时间")
    private Long payTime;

	    /**
     *  退款时间
     */
    @Column(name = "refund_time")
	@ApiModelProperty(value = "退款时间")
    private Long refundTime;

	/**
	 *  退款状态
	 */
	@Column(name = "refund_status")
	@ApiModelProperty(value = "退款的状态 0--未退还；1--已退还所有钱；2--已退还部分押金（保留违章预备金）；3--已退还所有押金（扣除该扣除的）")
	private Integer refundStatus;

	/**
	 *  是否有优惠
	 */
	@Column(name = "has_discount")
	@ApiModelProperty(value = "是否有优惠 0--无优惠；1--有优惠")
	private Integer hasDiscount;

	/**
	 *  是否有优惠
	 */
	@Column(name = "has_member_right")
	@ApiModelProperty(value = "是否有使用会员权益")
	private Integer hasMemberRight;

	/**
	 *  是否已支付
	 */
	@Column(name = "has_pay")
	@ApiModelProperty(value = "是否已支付")
	private Integer hasPay;

    /**
     * 乐观锁,修改版本号
     */
    @ApiModelProperty(value = "乐观锁,修改版本号")
    @Version
    private Integer version;

	/**
	 * 下单来源 1--app；2--小程序
	 */
	@ApiModelProperty(value = "下单来源 1--app；2--小程序")
	@Column(name = "order_origin")
	private Integer orderOrigin;

	/**
	 * 支付来源 1--app；2--小程序
	 */
	@ApiModelProperty(value = "支付来源 1--app；2--小程序")
	@Column(name = "pay_origin")
	private Integer payOrigin;
}
